from typing import Tuple, Set, Iterable, List

class Arc:
    def __init__(self, circle: Circle, angleRadians: float): ...
    def __init__(self, center: Point3d, radius: float, angleRadians: float): ...
    def __init__(self, startPoint: Point3d, pointOnInterior: Point3d, endPoint: Point3d): ...
    def __init__(self, pointA: Point3d, tangentA: Vector3d, pointB: Point3d): ...
    @property
    def IsValid(self) -> bool: ...
    @property
    def IsCircle(self) -> bool: ...
    @property
    def Radius(self) -> float: ...
    @property
    def Diameter(self) -> float: ...
    @property
    def Plane(self) -> Plane: ...
    @property
    def Center(self) -> Point3d: ...
    @property
    def Circumference(self) -> float: ...
    @property
    def Length(self) -> float: ...
    @property
    def StartPoint(self) -> Point3d: ...
    @property
    def MidPoint(self) -> Point3d: ...
    @property
    def EndPoint(self) -> Point3d: ...
    @property
    def AngleDomain(self) -> Interval: ...
    @property
    def StartAngle(self) -> float: ...
    @property
    def EndAngle(self) -> float: ...
    @property
    def StartAngleDegrees(self) -> float: ...
    @property
    def EndAngleDegrees(self) -> float: ...
    @property
    def AngleDegrees(self) -> float: ...
    def Trim(self, domain: Interval) -> bool: ...
    def BoundingBox(self) -> BoundingBox: ...
    def PointAt(self, t: float) -> Point3d: ...
    def TangentAt(self, t: float) -> Vector3d: ...
    def ClosestParameter(self, testPoint: Point3d) -> float: ...
    def ClosestPoint(self, testPoint: Point3d) -> Point3d: ...
    def Reverse(self) -> None: ...
    def Transform(self, xform: Transform) -> bool: ...
    def ToNurbsCurve(self) -> NurbsCurve: ...

class ArchivableDictionary: ...

class BezierCurve:
    @property
    def Dimension(self) -> int: ...
    @property
    def IsValid(self) -> bool: ...
    @property
    def IsRational(self) -> bool: ...
    @property
    def ControlVertexCount(self) -> int: ...
    def PointAt(self, t: float) -> Point3d: ...
    def TangentAt(self, t: float) -> Vector3d: ...
    def CurvatureAt(self, t: float) -> Vector3d: ...
    def ToNurbsCurve(self) -> NurbsCurve: ...
    def MakeRational(self) -> bool: ...
    def MakeNonRational(self) -> bool: ...
    def IncreaseDegree(self, desiredDegree: int) -> bool: ...
    def ChangeDimension(self, desiredDimension: int) -> bool: ...

class Bitmap: ...

class BoundingBox:
    def __init__(self, min: Point3d, max: Point3d): ...
    def __init__(self, minX: float, minY: float, minZ: float, maxX: float, maxY: float, maxZ: float): ...
    @property
    def IsValid(self) -> bool: ...
    @property
    def Min(self) -> Point3d: ...
    @property
    def Max(self) -> Point3d: ...
    @property
    def Center(self) -> Point3d: ...
    @property
    def Area(self) -> float: ...
    @property
    def Volume(self) -> float: ...
    @property
    def Diagonal(self) -> Vector3d: ...
    def ClosestPoint(self, point: Point3d) -> Point3d: ...
    def Inflate(self, amount: float) -> None: ...
    def Inflate(self, amount: float) -> None: ...
    def Contains(self, point: Point3d) -> bool: ...
    def IsDegenerate(self, tolerance: float) -> int: ...
    def Transform(self, xform: Transform) -> bool: ...
    def ToBrep(self) -> Brep: ...
    @staticmethod
    def Union(other: BoundingBox) -> None: ...

class Box:
    @property
    def IsValid(self) -> bool: ...
    @property
    def Center(self) -> Point3d: ...
    @property
    def Area(self) -> float: ...
    @property
    def Volume(self) -> float: ...
    def PointAt(self, x: float, y: float, z: float) -> Point3d: ...
    def ClosestPoint(self, point: Point3d) -> Point3d: ...
    def Transform(self, xform: Transform) -> bool: ...

class BrepEdgeList: ...

class BrepFaceList: ...

class BrepSurfaceList: ...

class Circle:
    def __init__(self, radius: float): ...
    def __init__(self, center: Point3d, radius: float): ...
    @property
    def IsValid(self) -> bool: ...
    @property
    def Radius(self) -> float: ...
    @property
    def Diameter(self) -> float: ...
    @property
    def Center(self) -> Point3d: ...
    @property
    def Normal(self) -> Vector3d: ...
    @property
    def Circumference(self) -> float: ...
    def PointAt(self, t: float) -> Point3d: ...
    def TangentAt(self, t: float) -> Vector3d: ...
    def DerivativeAt(self, derivative: int, t: float) -> Vector3d: ...
    def ClosestPoint(self, testPoint: Point3d) -> Point3d: ...
    def Translate(self, delta: Vector3d) -> bool: ...
    def Reverse(self) -> None: ...
    def ToNurbsCurve(self) -> NurbsCurve: ...

class CommonObject:
    @property
    def IsValid(self) -> bool: ...

class ComponentIndex:
    @property
    def ComponentIndexType(self) -> ComponentIndexType: ...
    @property
    def Index(self) -> int: ...

class Cone:
    @property
    def Height(self) -> float: ...
    @property
    def Radius(self) -> float: ...
    @property
    def IsValid(self) -> bool: ...
    @property
    def BasePoint(self) -> Point3d: ...
    @property
    def ApexPoint(self) -> Point3d: ...
    @property
    def Axis(self) -> Vector3d: ...
    def ToNurbsSurface(self) -> NurbsSurface: ...
    def ToBrep(self, capBottom: bool) -> Brep: ...

class ConstructionPlane:
    @property
    def Plane(self) -> Plane: ...
    @property
    def GridSpacing(self) -> float: ...
    @property
    def SnapSpacing(self) -> float: ...
    @property
    def GridLineCount(self) -> int: ...
    @property
    def ThickLineFrequency(self) -> int: ...
    @property
    def DepthBuffered(self) -> bool: ...
    @property
    def Name(self) -> str: ...

class Cylinder:
    def __init__(self, baseCircle: Circle): ...
    def __init__(self, baseCircle: Circle, height: float): ...
    @property
    def IsValid(self) -> bool: ...
    @property
    def IsFinite(self) -> bool: ...
    @property
    def Center(self) -> Point3d: ...
    @property
    def Axis(self) -> Vector3d: ...
    @property
    def TotalHeight(self) -> float: ...
    @property
    def Height1(self) -> float: ...
    @property
    def Height2(self) -> float: ...
    @property
    def Radius(self) -> float: ...
    def CircleAt(self, linearParameter: float) -> Circle: ...
    def ToBrep(self, capBottom: bool, capTop: bool) -> Brep: ...
    def ToNurbsSurface(self) -> NurbsSurface: ...

class DracoCompression: ...

class DracoCompressionOptions: ...

class EarthAnchorPoint:
    @property
    def EarthBasepointLatitude(self) -> float: ...
    @property
    def EarthBasepointLongitude(self) -> float: ...
    @property
    def EarthBasepointElevation(self) -> float: ...
    @property
    def EarthBasepointElevationZero(self) -> BasepointZero: ...
    @property
    def ModelBasePoint(self) -> Point3d: ...
    @property
    def ModelNorth(self) -> Vector3d: ...
    @property
    def ModelEast(self) -> Vector3d: ...
    @property
    def Name(self) -> str: ...
    @property
    def Description(self) -> str: ...
    def EarthLocationIsSet(self) -> bool: ...
    def GetModelCompass(self) -> Plane: ...
    def GetModelToEarthTransform(self, modelUnitSystem: UnitSystem) -> Transform: ...

class Ellipse: ...

class File3dm:
    @property
    def StartSectionComments(self) -> str: ...
    @property
    def ApplicationName(self) -> str: ...
    @property
    def ApplicationUrl(self) -> str: ...
    @property
    def ApplicationDetails(self) -> str: ...
    @property
    def CreatedBy(self) -> str: ...
    @property
    def LastEditedBy(self) -> str: ...
    @property
    def Revision(self) -> int: ...
    @property
    def Settings(self) -> File3dmSettings: ...
    @property
    def Objects(self) -> File3dmObjectTable: ...
    @property
    def Materials(self) -> Iterable[Material]: ...
    @property
    def Layers(self) -> Iterable[Layer]: ...
    @property
    def DimStyles(self) -> Iterable[DimensionStyle]: ...
    @property
    def InstanceDefinitions(self) -> Iterable[InstanceDefinitionGeometry]: ...
    @property
    def Views(self) -> Iterable[ViewInfo]: ...
    @property
    def NamedViews(self) -> Iterable[ViewInfo]: ...
    @property
    def PlugInData(self) -> File3dmPlugInDataTable: ...
    @property
    def Strings(self) -> File3dmStringTable: ...
    @staticmethod
    def Read(path: str) -> File3dm: ...
    @staticmethod
    def ReadNotes(path: str) -> str: ...
    @staticmethod
    def ReadArchiveVersion(path: str) -> int: ...
    @staticmethod
    def FromByteArray(bytes: List[byte]) -> File3dm: ...
    def Write(self, path: str, version: int) -> bool: ...

class File3dmBitmapTable: ...

class File3dmDimStyleTable:
    def FindIndex(self, index: int) -> DimensionStyle: ...

class File3dmGroupTable:
    def FindIndex(self, groupIndex: int) -> Group: ...
    def FindName(self, name: str) -> Group: ...
    def GroupMembers(self, groupIndex: int) -> List[File3dmObject]: ...

class File3dmInstanceDefinitionTable:
    def Add(self, name: str, description: str, url: str, urlTag: str, basePoint: Point3d, geometry: Iterable[GeometryBase], attributes: Iterable[ObjectAttributes]) -> int: ...

class File3dmLayerTable:
    def AddLayer(self, name: str, color: Tuple[int, int, int, int]) -> int: ...
    def FindName(self, name: str, parentId: Guid) -> Layer: ...
    def FindIndex(self, index: int) -> Layer: ...

class File3dmMaterialTable:
    def FindIndex(self, index: int) -> Material: ...

class File3dmObject:
    @property
    def Attributes(self) -> ObjectAttributes: ...
    @property
    def Geometry(self) -> GeometryBase: ...

class File3dmObjectTable:
    def AddPoint(self, x: float, y: float, z: float) -> Guid: ...
    def AddPoint(self, x: float, y: float, z: float) -> Guid: ...
    def AddPoint(self, x: float, y: float, z: float) -> Guid: ...
    def AddPointCloud(self, cloud: PointCloud) -> Guid: ...
    def AddLine(self, _from: Point3d, to: Point3d) -> Guid: ...
    def AddPolyline(self, points: Iterable[Point3d]) -> Guid: ...
    def AddArc(self, arc: Arc) -> Guid: ...
    def AddCircle(self, circle: Circle) -> Guid: ...
    def AddEllipse(self, ellipse: Ellipse) -> Guid: ...
    def AddSphere(self, sphere: Sphere) -> Guid: ...
    def AddCurve(self, curve: Curve) -> Guid: ...
    def AddTextDot(self, text: str, location: Point3d) -> Guid: ...
    def AddSurface(self, surface: Surface) -> Guid: ...
    def AddExtrusion(self, extrusion: Extrusion) -> Guid: ...
    def AddMesh(self, mesh: Mesh) -> Guid: ...
    def AddBrep(self, brep: Brep) -> Guid: ...
    def AddHatch(self, hatch: Hatch) -> Guid: ...
    def Add(self, item: File3dmObject) -> None: ...
    def GetBoundingBox(self) -> BoundingBox: ...
    def Delete(self, objectId: Guid) -> bool: ...

class File3dmPlugInData: ...

class File3dmPlugInDataTable: ...

class File3dmSettings:
    @property
    def ModelUrl(self) -> str: ...
    @property
    def ModelBasePoint(self) -> Point3d: ...
    @property
    def ModelAbsoluteTolerance(self) -> float: ...
    @property
    def ModelAngleToleranceRadians(self) -> float: ...
    @property
    def ModelAngleToleranceDegrees(self) -> float: ...
    @property
    def ModelRelativeTolerance(self) -> float: ...
    @property
    def PageAbsoluteTolerance(self) -> float: ...
    @property
    def PageAngleToleranceRadians(self) -> float: ...
    @property
    def PageAngleToleranceDegrees(self) -> float: ...
    @property
    def PageRelativeTolerance(self) -> float: ...
    @property
    def ModelUnitSystem(self) -> UnitSystem: ...
    @property
    def PageUnitSystem(self) -> UnitSystem: ...

class File3dmStringTable:
    def Delete(self, section: str, entry: str) -> None: ...

class File3dmViewTable:
    def Add(self, item: ViewInfo) -> None: ...

class File3dmWriteOptions:
    @property
    def Version(self) -> int: ...
    @property
    def SaveUserData(self) -> bool: ...

class FileReference:
    @property
    def FullPath(self) -> str: ...
    @property
    def RelativePath(self) -> str: ...
    @staticmethod
    def CreateFromFullPath(fullPath: str) -> FileReference: ...
    @staticmethod
    def CreateFromFullAndRelativePaths(fullPath: str, relativePath: str) -> FileReference: ...

class Font:
    @property
    def QuartetName(self) -> str: ...
    @property
    def FaceName(self) -> str: ...
    @property
    def PostScriptName(self) -> str: ...
    @property
    def RichTextFontName(self) -> str: ...
    @property
    def Bold(self) -> bool: ...
    @property
    def Italic(self) -> bool: ...
    @property
    def Underlined(self) -> bool: ...
    @property
    def StrikeOut(self) -> bool: ...
    @property
    def IsEngravingFont(self) -> bool: ...
    @property
    def IsSymbolFont(self) -> bool: ...
    @property
    def IsSingleStrokeFont(self) -> bool: ...
    @property
    def IsSimulated(self) -> bool: ...
    @property
    def PointSize(self) -> float: ...
    @property
    def FamilyName(self) -> str: ...

class Intersection:
    @staticmethod
    def LinePlane(line: Line, plane: Plane, lineParameter: float) -> bool: ...
    @staticmethod
    def PlanePlane(planeA: Plane, planeB: Plane, intersectionLine: Line) -> bool: ...
    @staticmethod
    def PlanePlanePlane(planeA: Plane, planeB: Plane, planeC: Plane, intersectionPoint: Point3d) -> bool: ...
    @staticmethod
    def PlaneSphere(plane: Plane, sphere: Sphere, intersectionCircle: Circle) -> PlaneSphereIntersection: ...
    @staticmethod
    def SphereSphere(sphereA: Sphere, sphereB: Sphere, intersectionCircle: Circle) -> SphereSphereIntersection: ...
    @staticmethod
    def LineBox(line: Line, box: BoundingBox, tolerance: float, lineParameters: Interval) -> bool: ...

class Interval:
    def __init__(self, t0: float, t1: float): ...
    @property
    def T0(self) -> float: ...
    @property
    def T1(self) -> float: ...

class Line:
    def __init__(self, _from: Point3d, to: Point3d): ...
    @property
    def From(self) -> Point3d: ...
    @property
    def To(self) -> Point3d: ...
    @property
    def IsValid(self) -> bool: ...
    @property
    def Length(self) -> float: ...
    @property
    def Direction(self) -> Vector3d: ...
    @property
    def UnitTangent(self) -> Vector3d: ...
    def PointAt(self, t: float) -> Point3d: ...

class MeshFaceList:
    @property
    def Count(self) -> int: ...
    @property
    def QuadCount(self) -> int: ...
    @property
    def TriangleCount(self) -> int: ...
    @property
    def Capacity(self) -> int: ...
    def Clear(self) -> None: ...
    def Destroy(self) -> None: ...
    def AddFace(self, face: MeshFace) -> int: ...
    def AddFace(self, face: MeshFace) -> int: ...
    def SetFace(self, index: int, face: MeshFace) -> bool: ...
    def SetFace(self, index: int, face: MeshFace) -> bool: ...
    def ConvertQuadsToTriangles(self) -> bool: ...
    def ConvertNonPlanarQuadsToTriangles(self, planarTolerance: float, angleToleranceRadians: float, splitMethod: int) -> int: ...
    def ConvertTrianglesToQuads(self, angleToleranceRadians: float, minimumDiagonalLengthRatio: float) -> bool: ...
    def CullDegenerateFaces(self) -> int: ...
    def IsHidden(self, faceIndex: int) -> bool: ...
    def HasNakedEdges(self, faceIndex: int) -> bool: ...

class MeshingParameters:
    def __init__(self, density: float): ...
    def __init__(self, density: float, minimumEdgeLength: float): ...
    @property
    def Default(self) -> MeshingParameters: ...
    @property
    def FastRenderMesh(self) -> MeshingParameters: ...
    @property
    def QualityRenderMesh(self) -> MeshingParameters: ...
    @property
    def DefaultAnalysisMesh(self) -> MeshingParameters: ...
    @property
    def TextureRange(self) -> MeshingParameterTextureRange: ...
    @property
    def JaggedSeams(self) -> bool: ...
    @property
    def RefineGrid(self) -> bool: ...
    @property
    def SimplePlanes(self) -> bool: ...
    @property
    def ComputeCurvature(self) -> bool: ...
    @property
    def ClosedObjectPostProcess(self) -> bool: ...
    @property
    def GridMinCount(self) -> int: ...
    @property
    def GridMaxCount(self) -> int: ...
    @property
    def GridAngle(self) -> float: ...
    @property
    def GridAspectRatio(self) -> float: ...
    @property
    def GridAmplification(self) -> float: ...
    @property
    def Tolerance(self) -> float: ...
    @property
    def MinimumTolerance(self) -> float: ...
    @property
    def RelativeTolerance(self) -> float: ...
    @property
    def MinimumEdgeLength(self) -> float: ...
    @property
    def MaximumEdgeLength(self) -> float: ...
    @property
    def RefineAngle(self) -> float: ...

class MeshNormalList: ...

class MeshTextureCoordinateList: ...

class MeshTopologyEdgeList:
    def EdgeLine(self, topologyEdgeIndex: int) -> Line: ...

class MeshVertexColorList:
    @property
    def Count(self) -> int: ...
    @property
    def Capacity(self) -> int: ...
    def Clear(self) -> None: ...
    def Add(self, red: int, green: int, blue: int) -> int: ...

class MeshVertexList:
    @property
    def UseDoublePrecisionVertices(self) -> bool: ...
    def Clear(self) -> None: ...
    def Destroy(self) -> None: ...
    def Add(self, x: float, y: float, z: float) -> int: ...
    def IsHidden(self, vertexIndex: int) -> bool: ...
    def Hide(self, vertexIndex: int) -> None: ...
    def Show(self, vertexIndex: int) -> None: ...
    def HideAll(self) -> None: ...
    def ShowAll(self) -> None: ...
    def CullUnused(self) -> int: ...
    def CombineIdentical(self, ignoreNormals: bool, ignoreAdditional: bool) -> bool: ...

class NurbsCurveKnotList:
    @property
    def IsClampedStart(self) -> bool: ...
    @property
    def IsClampedEnd(self) -> bool: ...
    def InsertKnot(self, value: float) -> bool: ...
    def KnotMultiplicity(self, index: int) -> int: ...
    def CreateUniformKnots(self, knotSpacing: float) -> bool: ...
    def CreatePeriodicKnots(self, knotSpacing: float) -> bool: ...
    def SuperfluousKnot(self, start: bool) -> float: ...

class NurbsCurvePointList:
    @property
    def ControlPolygonLength(self) -> float: ...
    def ChangeEndWeights(self, w0: float, w1: float) -> bool: ...
    def MakeRational(self) -> bool: ...
    def MakeNonRational(self) -> bool: ...

class NurbsSurfaceKnotList:
    def InsertKnot(self, value: float) -> bool: ...
    def KnotMultiplicity(self, index: int) -> int: ...
    def CreateUniformKnots(self, knotSpacing: float) -> bool: ...
    def CreatePeriodicKnots(self, knotSpacing: float) -> bool: ...
    def SuperfluousKnot(self, start: bool) -> float: ...

class NurbsSurfacePointList:
    @property
    def CountU(self) -> int: ...
    @property
    def CountV(self) -> int: ...

class PhysicallyBasedMaterial:
    @property
    def Subsurface(self) -> float: ...
    @property
    def SubsurfaceScatteringRadius(self) -> float: ...
    @property
    def Metallic(self) -> float: ...
    @property
    def Specular(self) -> float: ...
    @property
    def ReflectiveIOR(self) -> float: ...
    @property
    def SpecularTint(self) -> float: ...
    @property
    def Roughness(self) -> float: ...
    @property
    def Anisotropic(self) -> float: ...
    @property
    def AnisotropicRotation(self) -> float: ...
    @property
    def Sheen(self) -> float: ...
    @property
    def SheenTint(self) -> float: ...
    @property
    def Clearcoat(self) -> float: ...
    @property
    def ClearcoatRoughness(self) -> float: ...
    @property
    def OpacityIOR(self) -> float: ...
    @property
    def Opacity(self) -> float: ...
    @property
    def OpacityRoughness(self) -> float: ...

class Plane:
    def __init__(self, origin: Point3d, normal: Vector3d): ...
    def __init__(self, origin: Point3d, xPoint: Point3d, yPoint: Point3d): ...
    def __init__(self, origin: Point3d, xDirection: Vector3d, yDirection: Vector3d): ...
    def __init__(self, a: float, b: float, c: float, d: float): ...
    @property
    def Origin(self) -> Point3d: ...
    @property
    def XAxis(self) -> Vector3d: ...
    @property
    def YAxis(self) -> Vector3d: ...
    @property
    def ZAxis(self) -> Vector3d: ...

class Point2d:
    def __init__(self, x: float, y: float): ...
    @property
    def X(self) -> float: ...
    @property
    def Y(self) -> float: ...
    def DistanceTo(self, other: Point2d) -> float: ...

class Point2f:
    def __init__(self, x: float, y: float): ...
    @property
    def X(self) -> float: ...
    @property
    def Y(self) -> float: ...

class Point3d:
    def __init__(self, x: float, y: float, z: float): ...
    @property
    def Unset(self) -> Point3d: ...
    @property
    def X(self) -> float: ...
    @property
    def Y(self) -> float: ...
    @property
    def Z(self) -> float: ...
    def DistanceTo(self, other: Point3d) -> float: ...
    def Transform(self, xform: Transform) -> None: ...

class Point3dList:
    def __init__(self, initialCapacity: int): ...
    @property
    def BoundingBox(self) -> BoundingBox: ...
    def Add(self, x: float, y: float, z: float) -> None: ...
    def Transform(self, xform: Transform) -> None: ...
    def SetAllX(self, xValue: float) -> None: ...
    def SetAllY(self, yValue: float) -> None: ...
    def SetAllZ(self, zValue: float) -> None: ...

class Point3f:
    def __init__(self, x: float, y: float, z: float): ...
    @property
    def X(self) -> float: ...
    @property
    def Y(self) -> float: ...
    @property
    def Z(self) -> float: ...

class Point4d:
    def __init__(self, x: float, y: float, z: float, w: float): ...
    @property
    def X(self) -> float: ...
    @property
    def Y(self) -> float: ...
    @property
    def Z(self) -> float: ...
    @property
    def W(self) -> float: ...

class PointCloudItem:
    @property
    def Location(self) -> Point3d: ...
    @property
    def X(self) -> float: ...
    @property
    def Y(self) -> float: ...
    @property
    def Z(self) -> float: ...
    @property
    def Normal(self) -> Vector3d: ...
    @property
    def Color(self) -> Tuple[int, int, int, int]: ...
    @property
    def Hidden(self) -> bool: ...
    @property
    def Index(self) -> int: ...

class Sphere:
    def __init__(self, center: Point3d, radius: float): ...
    @property
    def IsValid(self) -> bool: ...
    @property
    def Diameter(self) -> float: ...
    @property
    def Radius(self) -> float: ...
    @property
    def Center(self) -> Point3d: ...
    @property
    def NorthPole(self) -> Point3d: ...
    @property
    def SouthPole(self) -> Point3d: ...
    def LatitudeRadians(self, radians: float) -> Circle: ...
    def LatitudeDegrees(self, degrees: float) -> Circle: ...
    def LongitudeRadians(self, radians: float) -> Circle: ...
    def PointAt(self, longitudeRadians: float, latitudeRadians: float) -> Point3d: ...
    def NormalAt(self, longitudeRadians: float, latitudeRadians: float) -> Vector3d: ...
    def ClosestPoint(self, testPoint: Point3d) -> Point3d: ...
    def ToBrep(self) -> Brep: ...
    def ToNurbsSurface(self) -> NurbsSurface: ...

class Texture:
    @property
    def FileName(self) -> str: ...

class Transform:
    def __init__(self, diagonalValue: float): ...
    @property
    def IsIdentity(self) -> bool: ...
    @property
    def IsValid(self) -> bool: ...
    @property
    def IsZero(self) -> bool: ...
    @property
    def IsZero4x4(self) -> bool: ...
    @property
    def IsZeroTransformation(self) -> bool: ...
    @staticmethod
    def Translation(motion: Vector3d) -> Transform: ...
    @staticmethod
    def Translation(motion: Vector3d) -> Transform: ...
    @staticmethod
    def Scale(anchor: Point3d, scaleFactor: float) -> Transform: ...
    @staticmethod
    def Scale(anchor: Point3d, scaleFactor: float) -> Transform: ...
    @staticmethod
    def Rotation(sinAngle: float, cosAngle: float, rotationAxis: Vector3d, rotationCenter: Point3d) -> Transform: ...
    @staticmethod
    def Mirror(pointOnMirrorPlane: Point3d, normalToMirrorPlane: Vector3d) -> Transform: ...
    @staticmethod
    def Mirror(pointOnMirrorPlane: Point3d, normalToMirrorPlane: Vector3d) -> Transform: ...
    def TryGetInverse(self, inverseTransform: Transform) -> bool: ...
    def TransformBoundingBox(self, bbox: BoundingBox) -> BoundingBox: ...
    def Transpose(self) -> Transform: ...
    def ToFloatArray(self, rowDominant: bool) -> List[float]: ...

class Vector2d:
    def __init__(self, x: float, y: float): ...
    @property
    def X(self) -> float: ...
    @property
    def Y(self) -> float: ...

class Vector3d:
    def __init__(self, x: float, y: float, z: float): ...
    @property
    def X(self) -> float: ...
    @property
    def Y(self) -> float: ...
    @property
    def Z(self) -> float: ...

class Vector3f:
    def __init__(self, x: float, y: float, z: float): ...
    @property
    def X(self) -> float: ...
    @property
    def Y(self) -> float: ...
    @property
    def Z(self) -> float: ...

class ViewInfo:
    @property
    def Name(self) -> str: ...
    @property
    def ShowWallpaperInGrayScale(self) -> bool: ...
    @property
    def WallpaperHidden(self) -> bool: ...
    @property
    def FocalBlurDistance(self) -> float: ...
    @property
    def FocalBlurAperture(self) -> float: ...
    @property
    def FocalBlurJitter(self) -> float: ...
    @property
    def FocalBlurSampleCount(self) -> uint: ...
    @property
    def Viewport(self) -> ViewportInfo: ...

class DimensionStyle(CommonObject):
    @property
    def Font(self) -> Font: ...
    @property
    def ArrowBlockId1(self) -> Guid: ...
    @property
    def ArrowBlockId2(self) -> Guid: ...
    @property
    def LeaderArrowBlockId(self) -> Guid: ...
    @property
    def SuppressExtension1(self) -> bool: ...
    @property
    def SuppressExtension2(self) -> bool: ...
    @property
    def SuppressArrow1(self) -> bool: ...
    @property
    def SuppressArrow2(self) -> bool: ...
    @property
    def AlternateBelowLine(self) -> bool: ...
    @property
    def DrawTextMask(self) -> bool: ...
    @property
    def LeaderHasLanding(self) -> bool: ...
    @property
    def DrawForward(self) -> bool: ...
    @property
    def TextUnderlined(self) -> bool: ...
    @property
    def ArrowLength(self) -> float: ...
    @property
    def LeaderArrowLength(self) -> float: ...
    @property
    def CentermarkSize(self) -> float: ...
    @property
    def TextGap(self) -> float: ...
    @property
    def TextHEight(self) -> float: ...
    @property
    def LengthFactor(self) -> float: ...
    @property
    def AlternateLengthFactor(self) -> float: ...
    @property
    def ToleranceUpperValue(self) -> float: ...
    @property
    def ToleranceLowerValue(self) -> float: ...
    @property
    def ToleranceHeightScale(self) -> float: ...
    @property
    def BaselineSpacing(self) -> float: ...
    @property
    def TextRotation(self) -> float: ...
    @property
    def StackHeightScale(self) -> float: ...
    @property
    def LeaderLandingLength(self) -> float: ...
    @property
    def HasFieldOverrides(self) -> bool: ...
    @property
    def IsChild(self) -> bool: ...
    @property
    def ParentId(self) -> Guid: ...
    def ScaleLengthValues(self, scale: float) -> None: ...
    def SetFieldOverride(self, field: Field) -> None: ...
    def ClearFieldOverride(self, field: Field) -> None: ...
    def ClearAllFieldOverrides(self) -> None: ...
    def IsChildOf(self, parentId: Guid) -> bool: ...

class GeometryBase(CommonObject):
    @property
    def ObjectType(self) -> ObjectType: ...
    @property
    def IsDeformable(self) -> bool: ...
    @property
    def HasBrepForm(self) -> bool: ...
    def Transform(self, xform: Transform) -> bool: ...
    def Translate(self, translationVector: Vector3d) -> bool: ...
    def Scale(self, scaleFactor: float) -> bool: ...
    def Rotate(self, angleRadians: float, rotationAxis: Vector3d, rotationCenter: Point3d) -> bool: ...
    def GetBoundingBox(self, accurate: bool) -> BoundingBox: ...
    def MakeDeformable(self) -> bool: ...
    def Duplicate(self) -> GeometryBase: ...

class Group(CommonObject): ...

class InstanceDefinition(CommonObject): ...

class Layer(CommonObject):
    @property
    def Name(self) -> str: ...
    @property
    def FullPath(self) -> str: ...
    @property
    def Id(self) -> Guid: ...
    @property
    def ParentLayerId(self) -> Guid: ...
    @property
    def IgesLevel(self) -> int: ...
    @property
    def Color(self) -> Tuple[int, int, int, int]: ...
    @property
    def PlotColor(self) -> Tuple[int, int, int, int]: ...
    @property
    def PlotWeight(self) -> float: ...
    @property
    def LinetypeIndex(self) -> int: ...
    @property
    def RenderMaterialIndex(self) -> int: ...
    def HasPerViewportSettings(self, viewportId: Guid) -> bool: ...
    def DeletePerViewportSettings(self, viewportId: Guid) -> None: ...
    def PerViewportColor(self, viewportId: Guid) -> Tuple[int, int, int, int]: ...
    def SetPerViewportColor(self, viewportId: Guid, color: Tuple[int, int, int, int]) -> None: ...
    def DeletePerViewportColor(self, viewportId: Guid) -> None: ...
    def GetPersistentVisibility(self) -> bool: ...
    def SetPersistentVisibility(self, persistentVisibility: bool) -> None: ...
    def UnsetPersistentVisibility(self) -> None: ...
    def GetPersistentLocking(self) -> bool: ...
    def SetPersistentLocking(self, persistentLocking: bool) -> None: ...
    def UnsetPersistentLocking(self) -> None: ...

class ModelComponent(CommonObject):
    @property
    def Id(self) -> Guid: ...

class ObjectAttributes(CommonObject):
    @property
    def Mode(self) -> ObjectMode: ...
    @property
    def IsInstanceDefinitionObject(self) -> bool: ...
    @property
    def Visible(self) -> bool: ...
    @property
    def CastsShadows(self) -> bool: ...
    @property
    def ReceivesShadows(self) -> bool: ...
    @property
    def LinetypeSource(self) -> ObjectLinetypeSource: ...
    @property
    def ColorSource(self) -> ObjectColorSource: ...
    @property
    def PlotColorSource(self) -> ObjectPlotColorSource: ...
    @property
    def PlotWeightSource(self) -> ObjectPlotWeightSource: ...
    @property
    def Name(self) -> str: ...
    @property
    def Url(self) -> str: ...
    @property
    def LayerIndex(self) -> int: ...
    @property
    def LinetypeIndex(self) -> int: ...
    @property
    def MaterialIndex(self) -> int: ...
    @property
    def MaterialSource(self) -> ObjectMaterialSource: ...
    @property
    def ObjectColor(self) -> Tuple[int, int, int, int]: ...
    @property
    def PlotColor(self) -> Tuple[int, int, int, int]: ...
    @property
    def DisplayOrder(self) -> int: ...
    @property
    def PlotWeight(self) -> float: ...
    @property
    def ObjectDecoration(self) -> ObjectDecoration: ...
    @property
    def WireDensity(self) -> int: ...
    @property
    def ViewportId(self) -> Guid: ...
    @property
    def GroupCount(self) -> int: ...
    def Transform(self, xform: Transform) -> bool: ...
    def HasDisplayModeOverride(self, viewportId: Guid) -> bool: ...
    def GetGroupList(self) -> List[int]: ...
    def AddToGroup(self, groupIndex: int) -> None: ...
    def RemoveFromGroup(self, groupIndex: int) -> None: ...
    def RemoveFromAllGroups(self) -> None: ...

class RenderSettings(CommonObject):
    @property
    def AmbientLight(self) -> Tuple[int, int, int, int]: ...
    @property
    def BackgroundColorTop(self) -> Tuple[int, int, int, int]: ...
    @property
    def BackgroundColorBottom(self) -> Tuple[int, int, int, int]: ...
    @property
    def UseHiddenLights(self) -> bool: ...
    @property
    def DepthCue(self) -> bool: ...
    @property
    def FlatShade(self) -> bool: ...
    @property
    def RenderBackFaces(self) -> bool: ...
    @property
    def RenderPoints(self) -> bool: ...
    @property
    def RenderCurves(self) -> bool: ...
    @property
    def RenderIsoParams(self) -> bool: ...
    @property
    def RenderMeshEdges(self) -> bool: ...
    @property
    def RenderAnnotations(self) -> bool: ...
    @property
    def UseViewportSize(self) -> bool: ...
    @property
    def ScaleBackgroundToFit(self) -> bool: ...
    @property
    def TransparentBackground(self) -> bool: ...
    @property
    def ImageDpi(self) -> float: ...
    @property
    def ShadowMapLevel(self) -> int: ...
    @property
    def NamedView(self) -> str: ...
    @property
    def SnapShot(self) -> str: ...
    @property
    def SpecificViewport(self) -> str: ...

class TextureMapping(CommonObject):
    @staticmethod
    def CreateSurfaceParameterMapping() -> TextureMapping: ...
    @staticmethod
    def CreatePlaneMapping(plane: Plane, dx: Interval, dy: Interval, dz: Interval) -> TextureMapping: ...
    @staticmethod
    def CreateCylinderMapping(cylinder: Cylinder, capped: bool) -> TextureMapping: ...
    @staticmethod
    def CreateSphereMapping(sphere: Sphere) -> TextureMapping: ...
    @staticmethod
    def CreateBoxMapping(plane: Plane, dx: Interval, dy: Interval, dz: Interval, capped: bool) -> TextureMapping: ...
    def TryGetMappingCylinder(self, cylinder: Cylinder) -> bool: ...
    def TryGetMappingSphere(self, sphere: Sphere) -> bool: ...
    def Evaluate(self, p: Point3d, n: Vector3d, t: Point3d) -> int: ...

class ViewportInfo(CommonObject):
    @property
    def IsValidFrustum(self) -> bool: ...
    @property
    def IsParallelProjection(self) -> bool: ...
    @property
    def IsPerspectiveProjection(self) -> bool: ...
    @property
    def IsTwoPointPerspectiveProjection(self) -> bool: ...
    @property
    def CameraLocation(self) -> Point3d: ...
    @property
    def CameraDirection(self) -> Vector3d: ...
    @property
    def CameraUp(self) -> Vector3d: ...
    @property
    def CameraX(self) -> Vector3d: ...
    @property
    def CameraY(self) -> Vector3d: ...
    @property
    def CameraZ(self) -> Vector3d: ...
    @property
    def ScreenPortAspect(self) -> float: ...
    @property
    def CameraAngle(self) -> float: ...
    @property
    def Camera35mmLensLength(self) -> float: ...
    @property
    def Id(self) -> Guid: ...
    def ChangeToParallelProjection(self, symmetricFrustum: bool) -> bool: ...
    def ChangeToPerspectiveProjection(self, targetDistance: float, symmetricFrustum: bool, lensLength: float) -> bool: ...
    def ChangeToTwoPointPerspectiveProjection(self, targetDistance: float, up: Vector3d, lensLength: float) -> bool: ...
    def SetCameraLocation(self, location: Point3d) -> bool: ...
    def SetCameraDirection(self, direction: Vector3d) -> bool: ...
    def SetCameraUp(self, up: Vector3d) -> bool: ...
    def SetFrustum(self, left: float, right: float, bottom: float, top: float, nearDistance: float, farDistance: float) -> bool: ...
    def SetScreenPort(self, left: int, right: int, bottom: int, top: int, near: int, far: int) -> bool: ...
    def GetScreenPort(self) -> Rectangle: ...
    def GetXform(self, sourceSystem: CoordinateSystem, destinationSystem: CoordinateSystem) -> Transform: ...
    def Extents(self, halfViewAngleRadians: float, bbox: BoundingBox) -> bool: ...
    def DollyExtents(self, geometry: Iterable[GeometryBase], border: float) -> bool: ...
    def FrustumCenterPoint(self, targetDistance: float) -> Point3d: ...
    def TargetDistance(self, useFrustumCenterFallback: bool) -> float: ...

class AnnotationBase(GeometryBase):
    @property
    def RichText(self) -> str: ...
    @property
    def PlainText(self) -> str: ...

class Brep(GeometryBase):
    @property
    def Faces(self) -> BrepFaceList: ...
    @property
    def Surfaces(self) -> BrepSurfaceList: ...
    @property
    def Edges(self) -> BrepEdgeList: ...
    @property
    def IsSolid(self) -> bool: ...
    @property
    def IsManifold(self) -> bool: ...
    @property
    def IsSurface(self) -> bool: ...
    @staticmethod
    def CreateFromMesh(mesh: Mesh, trimmedTriangles: bool) -> Brep: ...
    @staticmethod
    def CreateFromBox(box: BoundingBox) -> Brep: ...
    @staticmethod
    def CreateFromBox(box: BoundingBox) -> Brep: ...
    @staticmethod
    def CreateFromCylinder(cylinder: Cylinder, capBottom: bool, capTop: bool) -> Brep: ...
    @staticmethod
    def CreateFromSphere(sphere: Sphere) -> Brep: ...
    @staticmethod
    def CreateQuadSphere(sphere: Sphere) -> Brep: ...
    @staticmethod
    def CreateFromCone(cone: Cone, capBottom: bool) -> Brep: ...
    @staticmethod
    def CreateFromRevSurface(surface: RevSurface, capStart: bool, capEnd: bool) -> Brep: ...
    @staticmethod
    def CreateFromSurface(surface: Surface) -> Brep: ...
    @staticmethod
    def CreateTrimmedPlane(plane: Plane, curve: Curve) -> Brep: ...
    def Flip(self) -> None: ...

class Curve(GeometryBase):
    @property
    def Domain(self) -> Interval: ...
    @property
    def Dimension(self) -> int: ...
    @property
    def SpanCount(self) -> int: ...
    @property
    def Degree(self) -> int: ...
    @property
    def IsClosed(self) -> bool: ...
    @property
    def IsPeriodic(self) -> bool: ...
    @property
    def PointAtStart(self) -> Point3d: ...
    @property
    def PointAtEnd(self) -> Point3d: ...
    @property
    def TangentAtStart(self) -> Vector3d: ...
    @property
    def TangentAtEnd(self) -> Vector3d: ...
    @staticmethod
    def CreateControlPointCurve(points: Iterable[Point3d], degree: int) -> Curve: ...
    def ChangeDimension(self, desiredDimension: int) -> bool: ...
    def IsLinear(self) -> bool: ...
    def IsPolyline(self) -> bool: ...
    def TryGetPolyline(self) -> Polyline: ...
    def IsArc(self) -> bool: ...
    def TryGetArc(self, arc: Arc) -> bool: ...
    def IsCircle(self) -> bool: ...
    def TryGetCircle(self, circle: Circle) -> bool: ...
    def IsEllipse(self) -> bool: ...
    def TryGetEllipse(self, ellipse: Ellipse) -> bool: ...
    def IsPlanar(self) -> bool: ...
    def ChangeClosedCurveSeam(self, t: float) -> bool: ...
    def IsClosable(self, tolerance: float) -> bool: ...
    def Reverse(self) -> bool: ...
    def ClosedCurveOrientation(self) -> CurveOrientation: ...
    def PointAt(self, t: float) -> Point3d: ...
    def SetStartPoint(self, point: Point3d) -> bool: ...
    def SetEndPoint(self, point: Point3d) -> bool: ...
    def TangentAt(self, t: float) -> Vector3d: ...
    def CurvatureAt(self, t: float) -> Vector3d: ...
    def FrameAt(self, t: float, plane: Plane) -> bool: ...
    def GetCurveParameterFromNurbsFormParameter(self, nurbsParameter: float, curveParameter: float) -> bool: ...
    def GetNurbsFormParameterFromCurveParameter(self, curveParameter: float, nurbsParameter: float) -> bool: ...
    def Trim(self, t0: float, t1: float) -> Curve: ...
    def Split(self, t: float) -> List[Curve]: ...
    def ToNurbsCurve(self) -> NurbsCurve: ...
    def ToNurbsCurve(self) -> NurbsCurve: ...

class Hatch(GeometryBase):
    @property
    def PatternIndex(self) -> int: ...
    @property
    def PatternRotation(self) -> float: ...
    @property
    def BasePoint(self) -> Point3d: ...
    @property
    def Plane(self) -> Plane: ...
    @property
    def PatternScale(self) -> float: ...
    def ScalePattern(self, xform: Transform) -> None: ...

class InstanceReference(GeometryBase): ...

class Light(GeometryBase):
    @property
    def IsEnabled(self) -> bool: ...
    @property
    def LightStyle(self) -> LightStyle: ...
    @property
    def IsPointLight(self) -> bool: ...
    @property
    def IsDirectionalLight(self) -> bool: ...
    @property
    def IsSpotLight(self) -> bool: ...
    @property
    def IsLinearLight(self) -> bool: ...
    @property
    def IsRectangularLight(self) -> bool: ...
    @property
    def Location(self) -> Point3d: ...
    @property
    def Direction(self) -> Vector3d: ...
    @property
    def PerpendicularDirection(self) -> Vector3d: ...
    @property
    def Intensity(self) -> float: ...
    @property
    def PowerWatts(self) -> float: ...
    @property
    def PowerLumens(self) -> float: ...
    @property
    def PowerCandela(self) -> float: ...
    @property
    def Ambient(self) -> Tuple[int, int, int, int]: ...
    @property
    def Diffuse(self) -> Tuple[int, int, int, int]: ...
    @property
    def Specular(self) -> Tuple[int, int, int, int]: ...
    @property
    def AttenuationVector(self) -> Vector3d: ...
    @property
    def SpotAngleRadians(self) -> float: ...
    @property
    def SpotExponent(self) -> float: ...
    @property
    def HotSpot(self) -> float: ...
    @property
    def Length(self) -> Vector3d: ...
    @property
    def Width(self) -> Vector3d: ...
    @property
    def ShadowIntensity(self) -> float: ...
    @property
    def Name(self) -> str: ...
    def SetAttenuation(self, a0: float, a1: float, a2: float) -> None: ...
    def GetAttenuation(self, d: float) -> float: ...

class Mesh(GeometryBase):
    @property
    def IsClosed(self) -> bool: ...
    @property
    def HasCachedTextureCoordinates(self) -> bool: ...
    @property
    def HasPrincipalCurvatures(self) -> bool: ...
    @property
    def Vertices(self) -> MeshVertexList: ...
    @property
    def TopologyEdges(self) -> MeshTopologyEdgeList: ...
    @property
    def Faces(self) -> MeshFaceList: ...
    @property
    def Normals(self) -> MeshVertexNormalList: ...
    @property
    def VertexColors(self) -> MeshVertexColorList: ...
    @property
    def TextureCoordinates(self) -> MeshTextureCoordinateList: ...
    @property
    def PartitionCount(self) -> int: ...
    @staticmethod
    def CreateFromSubDControlNet(subd: SubD) -> Mesh: ...
    def IsManifold(self) -> bool: ...
    def ClearTextureData(self) -> None: ...
    def ClearSurfaceData(self) -> None: ...
    def DestroyTopology(self) -> None: ...
    def DestroyTree(self) -> None: ...
    def DestroyPartition(self) -> None: ...
    def SetTextureCoordinates(self, tm: TextureMapping, xf: Transform, lazy: bool) -> None: ...
    def Compact(self) -> bool: ...
    def Append(self, other: Mesh) -> None: ...
    def CreatePartitions(self, maximumVertexCount: int, maximumTriangleCount: int) -> bool: ...

class Point(GeometryBase):
    def __init__(self, location: Point3d): ...
    @property
    def Location(self) -> Point3d: ...

class PointCloud(GeometryBase):
    @property
    def Count(self) -> int: ...
    @property
    def HiddenPointCount(self) -> int: ...
    @property
    def ContainsColors(self) -> bool: ...
    @property
    def ContainsNormals(self) -> bool: ...
    @property
    def ContainsHiddenFlags(self) -> bool: ...
    def ClearColors(self) -> None: ...
    def ClearNormals(self) -> None: ...
    def ClearHiddenFlags(self) -> None: ...
    def AppendNew(self) -> PointCloudItem: ...
    def InsertNew(self, index: int) -> PointCloudItem: ...
    def Merge(self, other: PointCloud) -> None: ...
    def Add(self, point: Point3d) -> None: ...
    def Add(self, point: Point3d) -> None: ...
    def Add(self, point: Point3d) -> None: ...
    def Add(self, point: Point3d) -> None: ...
    def AddRange(self, points: Iterable[Point3d]) -> None: ...
    def AddRange(self, points: Iterable[Point3d]) -> None: ...
    def AddRange(self, points: Iterable[Point3d]) -> None: ...
    def AddRange(self, points: Iterable[Point3d]) -> None: ...
    def Insert(self, index: int, point: Point3d) -> None: ...
    def Insert(self, index: int, point: Point3d) -> None: ...
    def Insert(self, index: int, point: Point3d) -> None: ...
    def Insert(self, index: int, point: Point3d) -> None: ...
    def InsertRange(self, index: int, points: Iterable[Point3d]) -> None: ...
    def RemoveAt(self, index: int) -> None: ...
    def GetPoints(self) -> List[Point3d]: ...
    def PointAt(self, index: int) -> Point3d: ...
    def GetNormals(self) -> List[Vector3d]: ...
    def GetColors(self) -> List[Color]: ...
    def ClosestPoint(self, testPoint: Point3d) -> int: ...

class PointGrid(GeometryBase): ...

class SubD(GeometryBase):
    @property
    def IsSolid(self) -> bool: ...
    def ClearEvaluationCache(self) -> None: ...
    def UpdateAllTagsAndSectorCoefficients(self) -> uint: ...
    def Subdivide(self, count: int) -> bool: ...

class Surface(GeometryBase):
    @property
    def IsSolid(self) -> bool: ...
    def SetDomain(self, direction: int, domain: Interval) -> bool: ...
    def Degree(self, direction: int) -> int: ...
    def SpanCount(self, direction: int) -> int: ...
    def PointAt(self, u: float, v: float) -> Point3d: ...
    def FrameAt(self, u: float, v: float, frame: Plane) -> bool: ...
    def Domain(self, direction: int) -> Interval: ...
    def GetSpanVector(self, direction: int) -> List[double]: ...
    def NormalAt(self, u: float, v: float) -> Vector3d: ...
    def IsClosed(self, direction: int) -> bool: ...
    def IsPeriodic(self, direction: int) -> bool: ...
    def IsSingular(self, side: int) -> bool: ...
    def IsAtSingularity(self, u: float, v: float, exact: bool) -> bool: ...
    def IsAtSeam(self, u: float, v: float) -> int: ...
    def IsoCurve(self, direction: int, constantParameter: float) -> Curve: ...
    def ToNurbsSurface(self) -> NurbsSurface: ...
    def ToNurbsSurface(self) -> NurbsSurface: ...
    def IsPlanar(self) -> bool: ...
    def IsSphere(self) -> bool: ...
    def IsCylinder(self) -> bool: ...
    def IsCone(self) -> bool: ...
    def IsTorus(self) -> bool: ...

class TextDot(GeometryBase):
    @property
    def Point(self) -> Point3d: ...
    @property
    def Text(self) -> str: ...
    @property
    def SecondaryText(self) -> str: ...
    @property
    def FontHeight(self) -> int: ...
    @property
    def FontFace(self) -> str: ...

class ArcCurve(Curve):
    def __init__(self, circle: Circle): ...
    def __init__(self, circle: Circle, t0: float, t1: float): ...
    @property
    def Arc(self) -> Arc: ...
    @property
    def IsCompleteCircle(self) -> bool: ...
    @property
    def Radius(self) -> float: ...
    @property
    def AngleRadians(self) -> float: ...
    @property
    def AngleDegrees(self) -> float: ...

class CurveProxy(Curve):
    @property
    def ProxyCurveIsReversed(self) -> bool: ...

class Extrusion(Surface):
    @property
    def PathStart(self) -> Point3d: ...
    @property
    def PathEnd(self) -> Point3d: ...
    @property
    def PathTangent(self) -> Vector3d: ...
    @property
    def MiterPlaneNormalAtStart(self) -> Vector3d: ...
    @property
    def MiterPlaneNormalAtEnd(self) -> Vector3d: ...
    @property
    def IsMiteredAtStart(self) -> bool: ...
    @property
    def IsMiteredAtEnd(self) -> bool: ...
    @property
    def IsSolid(self) -> bool: ...
    @property
    def IsCappedAtBottom(self) -> bool: ...
    @property
    def IsCappedAtTop(self) -> bool: ...
    @property
    def CapCount(self) -> int: ...
    @property
    def ProfileCount(self) -> int: ...
    @staticmethod
    def Create(planarCurve: Curve, height: float, cap: bool) -> Extrusion: ...
    @staticmethod
    def CreateBoxExtrusion(box: Box, cap: bool) -> Extrusion: ...
    @staticmethod
    def CreateCylinderExtrusion(cylinder: Cylinder, capBottom: bool, capTop: bool) -> Extrusion: ...
    @staticmethod
    def CreatePipeExtrusion(cylinder: Cylinder, otherRadius: float, capTop: bool, capBottom: bool) -> Extrusion: ...
    def ToBrep(self, splitKinkyFaces: bool) -> Brep: ...
    def SetPathAndUp(self, a: Point3d, b: Point3d, up: Vector3d) -> bool: ...
    def GetProfileTransformation(self, s: float) -> Transform: ...
    def GetProfilePlane(self, s: float) -> Plane: ...
    def GetPathPlane(self, s: float) -> Plane: ...
    def SetOuterProfile(self, outerProfile: Curve, cap: bool) -> bool: ...
    def AddInnerProfile(self, innerProfile: Curve) -> bool: ...
    def Profile3d(self, profileIndex: int, s: float) -> Curve: ...
    def Profile3d(self, profileIndex: int, s: float) -> Curve: ...
    def WallEdge(self, ci: ComponentIndex) -> Curve: ...
    def WallSurface(self, ci: ComponentIndex) -> Surface: ...
    def PathLineCurve(self) -> LineCurve: ...
    def ProfileIndex(self, profileParameter: float) -> int: ...
    def GetMesh(self, meshType: MeshType) -> Mesh: ...

class LineCurve(Curve):
    def __init__(self, _from: Point3d, to: Point3d): ...
    @property
    def Line(self) -> Line: ...

class NurbsCurve(Curve):
    def __init__(self, degree: int, pointCount: int): ...
    def __init__(self, dimension: int, rational: bool, order: int, pointCount: int): ...
    @property
    def Order(self) -> int: ...
    @property
    def IsRational(self) -> bool: ...
    @property
    def HasBezierSpans(self) -> bool: ...
    @property
    def Points(self) -> NurbsCurvePointList: ...
    @property
    def Knots(self) -> NurbsCurveKnotList: ...
    @staticmethod
    def CreateFromLine(line: Line) -> NurbsCurve: ...
    @staticmethod
    def CreateFromArc(arc: Arc) -> NurbsCurve: ...
    @staticmethod
    def CreateFromCircle(circle: Circle) -> NurbsCurve: ...
    @staticmethod
    def CreateFromEllipse(ellipse: Ellipse) -> NurbsCurve: ...
    @staticmethod
    def Create(periodic: bool, degree: int, points: Iterable[Point3d]) -> NurbsCurve: ...
    def IncreaseDegree(self, desiredDegree: int) -> bool: ...
    def MakePiecewiseBezier(self, setEndWeightsToOne: bool) -> bool: ...
    def Reparameterize(self, c: float) -> bool: ...
    def GrevilleParameter(self, index: int) -> float: ...
    def GrevillePoint(self, index: int) -> Point3d: ...

class NurbsSurface(Surface):
    @property
    def IsRational(self) -> bool: ...
    @property
    def OrderU(self) -> int: ...
    @property
    def OrderV(self) -> int: ...
    @property
    def KnotsU(self) -> NurbsSurfaceKnotList: ...
    @property
    def KnotsV(self) -> NurbsSurfaceKnotList: ...
    @property
    def Points(self) -> NurbsSurfacePointList: ...
    @staticmethod
    def Create(dimension: int, isRational: bool, order0: int, order1: int, controlPointCount0: int, controlPointCount1: int) -> NurbsSurface: ...
    @staticmethod
    def CreateFromCone(cone: Cone) -> NurbsSurface: ...
    @staticmethod
    def CreateFromSphere(sphere: Sphere) -> NurbsSurface: ...
    @staticmethod
    def CreateFromCylinder(cylinder: Cylinder) -> NurbsSurface: ...
    @staticmethod
    def CreateRuledSurface(curveA: Curve, curveB: Curve) -> NurbsSurface: ...
    def MakeRational(self) -> bool: ...
    def MakeNonRational(self) -> bool: ...
    def IncreaseDegreeU(self, desiredDegree: int) -> bool: ...
    def IncreaseDegreeV(self, desiredDegree: int) -> bool: ...

class PlaneSurface(Surface): ...

class PolyCurve(Curve):
    @property
    def SegmentCount(self) -> int: ...
    @property
    def IsNested(self) -> bool: ...
    @property
    def HasGap(self) -> bool: ...
    def SegmentCurve(self, index: int) -> Curve: ...
    def RemoveNesting(self) -> bool: ...
    def Explode(self) -> List[Curve]: ...
    def Append(self, line: Line) -> bool: ...
    def Append(self, line: Line) -> bool: ...
    def Append(self, line: Line) -> bool: ...
    def AppendSegment(self, curve: Curve) -> bool: ...
    def SegmentCurveParameter(self, polycurveParameter: float) -> float: ...
    def PolyCurveParameter(self, segmentIndex: int, segmentCurveParameter: float) -> float: ...
    def SegmentDomain(self, segmentIndex: int) -> Interval: ...
    def SegmentIndex(self, polycurveParameter: float) -> int: ...

class PolylineCurve(Curve):
    @property
    def PointCount(self) -> int: ...
    def Point(self, index: int) -> Point3d: ...
    def SetPoint(self, index: int, point: Point3d) -> None: ...
    def ToPolyline(self) -> Polyline: ...

class RevSurface(Surface):
    @staticmethod
    def Create(revoluteCurve: Curve, axisOfRevolution: Line, startAngleRadians: float, endAngleRadians: float) -> RevSurface: ...

class SurfaceProxy(Surface): ...

class BrepEdge(CurveProxy): ...

class BrepFace(SurfaceProxy):
    def UnderlyingSurface(self) -> Surface: ...
    def DuplicateFace(self, duplicateMeshes: bool) -> Brep: ...
    def DuplicateSurface(self) -> Surface: ...
    def GetMesh(self, meshType: MeshType) -> Mesh: ...

class File3dmRdkDocumentData(File3dmPlugInData): ...

class Material(ModelComponent):
    @property
    def RenderPlugInId(self) -> Guid: ...
    @property
    def Name(self) -> str: ...
    @property
    def Shine(self) -> float: ...
    @property
    def Transparency(self) -> float: ...
    @property
    def IndexOfRefraction(self) -> float: ...
    @property
    def FresnelIndexOfRefraction(self) -> float: ...
    @property
    def RefractionGlossiness(self) -> float: ...
    @property
    def ReflectionGlossiness(self) -> float: ...
    @property
    def FresnelReflections(self) -> bool: ...
    @property
    def DisableLighting(self) -> bool: ...
    @property
    def Reflectivity(self) -> float: ...
    @property
    def PreviewColor(self) -> Tuple[int, int, int, int]: ...
    @property
    def DiffuseColor(self) -> Tuple[int, int, int, int]: ...
    @property
    def AmbientColor(self) -> Tuple[int, int, int, int]: ...
    @property
    def EmissionColor(self) -> Tuple[int, int, int, int]: ...
    @property
    def SpecularColor(self) -> Tuple[int, int, int, int]: ...
    @property
    def ReflectionColor(self) -> Tuple[int, int, int, int]: ...
    @property
    def TransparentColor(self) -> Tuple[int, int, int, int]: ...
    @property
    def PhysicallyBased(self) -> PhysicallyBasedMaterial: ...
    def Default(self) -> None: ...
    def GetTexture(self, which: TextureType) -> Texture: ...
    def GetBitmapTexture(self) -> Texture: ...
    def SetBitmapTexture(self, filename: str) -> bool: ...
    def SetBitmapTexture(self, filename: str) -> bool: ...
    def GetBumpTexture(self) -> Texture: ...
    def SetBumpTexture(self, filename: str) -> bool: ...
    def SetBumpTexture(self, filename: str) -> bool: ...
    def GetEnvironmentTexture(self) -> Texture: ...
    def SetEnvironmentTexture(self, filename: str) -> bool: ...
    def SetEnvironmentTexture(self, filename: str) -> bool: ...
    def GetTransparencyTexture(self) -> Texture: ...
    def SetTransparencyTexture(self, filename: str) -> bool: ...
    def SetTransparencyTexture(self, filename: str) -> bool: ...

class Polyline(Point3dList):
    def __init__(self, initialCapacity: int): ...
    @property
    def IsValid(self) -> bool: ...
    @property
    def SegmentCount(self) -> int: ...
    @property
    def IsClosed(self) -> bool: ...
    @property
    def Length(self) -> float: ...
    def IsClosedWithinTolerance(self, tolerance: float) -> bool: ...
    def PointAt(self, t: float) -> Point3d: ...
    def TangentAt(self, t: float) -> Vector3d: ...
    def ClosestParameter(self, testPoint: Point3d) -> float: ...
    def ToNurbsCurve(self) -> NurbsCurve: ...
    def ToPolylineCurve(self) -> PolylineCurve: ...
    @staticmethod
    def CreateInscribedPolygon(circle: Circle, sideCount: int) -> Polyline: ...
    @staticmethod
    def CreateCircumscribedPolygon(circle: Circle, sideCount: int) -> Polyline: ...
    @staticmethod
    def CreateStarPolygon(circle: Circle, radius: float, cornerCount: int) -> Polyline: ...

